const port=3030;
var http = require('http');
var os = require('os');
var hostname = os.hostname();
var oracledb = require('oracledb');
var dbConfig = require('./dbconfig.js');
let error;
let user;
oracledb.getConnection (
    {
    user: dbConfig.dbuser,
    password: dbConfig.dbpassword,
    connectString: dbConfig.connectString,
    configDir: dbConfig.walletdir,
    walletLocation: dbConfig.walletdir,
    walletpassword: dbConfig.walletpassword
    },
    function(err, connection)
    {
        if (err) { error = err; return; }
        connection.execute (
            'select user from dual', [],
            function(err, result)
            {
                if (err) {cerror = err; return; }
                user = result.rows[0][0];
                console.log(`Check to see if your database connection worked at  http://<Your Compute IP Address>:${port}/`);
                error = null;
                connection.close(
                    function(err) {
                        if (err) { console.log(err); }
                    }
                );
            }
        )
    }
);

http.createServer(function(request, response) {
    response.writeHead(200, {'Content-Type': 'text plain' });
    if (error === null)
    {
        response.end('Connection test succeeded. You connected to ADB as ' + user + '!');
    }
    else if (error instanceof Error)
    {
        response.write('Connection test failed. Check the settings and redeploy app!\n');
        response.end(error.message);
    }
    else
    {
        response.end('Connection test pending. Refresh after a few seconds...');
    }
}).listen(port);
