import os
import oracledb

un = os.environ.get('ORAUSER')
pw = os.environ.get('ORAPASS')
cs = os.environ.get('ORATNS')
wallet_dir = os.environ.get('TNS_ADMIN')
wallet_pw = os.environ.get('WALLETPASS')

try:
  conn = oracledb.connect(user=un, password=pw, dsn=cs, config_dir=wallet_dir, wallet_location=wallet_dir, wallet_password=wallet_pw)
  sql="""SELECT channel_desc, TO_CHAR(SUM(amount_sold),'9,999,999,999') SALES$,
    RANK() OVER (ORDER BY SUM(amount_sold)) AS default_rank,
    RANK() OVER (ORDER BY SUM(amount_sold) DESC NULLS LAST) AS custom_rank
    FROM sh.sales, sh.products, sh.customers, sh.times, sh.channels, sh.countries
    WHERE sales.prod_id = products.prod_id
    AND sales.cust_id = customers.cust_id
    AND customers.country_id = countries.country_id
    AND sales.time_id = times.time_id
    AND sales.channel_id = channels.channel_id
    AND times.calendar_month_desc IN ('2000-09','2000-10')
    AND country_iso_code = :country_code
    GROUP BY channel_desc"""
  cursor = conn.cursor()
  cursor.execute(sql, country_code = 'US')

  print("CHANNEL_DESC            SALES          DEFAULT_RANK  CUSTOM_RANK")
  print("----------------------  -------------  ------------  -----------")
  for column_1, column_2, column_3, column_4 in cursor.fetchall():
      print(str(column_1).ljust(22), str(column_2).rjust(11), "  ", str(column_3).rjust(10), "  ", str(column_4).rjust(9))

except oracledb.DatabaseError as exc:
  err, = exc.args
  print("Oracle-Error-Code:", err.code)
  print("Oracle-Error-Message:", err.message)

finally:
  cursor.close()
  conn.close()